#---------------------------------------------------------------------------
# Copyright 2012 The Open Source Electronic Health Record Agent
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#---------------------------------------------------------------------------

#---------------------------------------------------------------------------
# Add location of OSEHRAHelper to the Python path
import sys
sys.path = ['C:/Users/contestant/OSEHRA/Dashboards/OSEHRA-Automated-Testing/Python'] + sys.path
#---------------------------------------------------------------------------

from OSEHRAHelper import PROMPT
from ConnectToVista import ConnectToVista
from InitializeFileman import InitializeFileman
from InitializeDevice import InitializeDevice
from SetupDomain import SetupDomain
from SetupCPRS import SetupCPRS
from AddHolidays import AddHolidays, AddHolidaysByConfig
from StartTaskMan import StartTaskMan
from CreateSystemManager import CreateSystemManager
from AddInstitutions import AddInstitutions, AddInstitutionsByConfig
from AddDivisions import AddDivisions, AddDivisionsByConfig
from AddDoctors import AddDoctors, AddDoctorsByConfig
from AddPatients import AddTestPatients, AddTestPatientsByConfig
from AddClinics import AddClinics, AddClinicsByConfig
from MakeAppointment import MakeAppointment
from VerifyOneAppointment import VerifyOneAppointment
from AddServiceSection import AddServiceSection, AddServiceSectionByConfig
from AddNotificationLetters import AddNotificationLetters, AddNotificationLettersByConfig
from DeleteDBA050 import DeleteDBA050
from AssignNotificationLetter import AssignNotificationLetter
from ReplaceDatabase import ReplaceDatabase
from JSONConfig import JSONConfigParser

""" reset the database """
#ReplaceDatabase()
configParser = JSONConfigParser('Scenario001.json')
VistA=ConnectToVista('Scenario001.log')
if 'OFF' == 'ON':
  VistA.startCoverage()
  VistA.wait(PROMPT)
is_visn0 = "ALABAMA" == "CALIFORNIA" # assume CALIFORNIA is using VISN0's data
if not is_visn0:
  InitializeFileman(VistA)
  InitializeDevice(VistA)
  SetupDomain(VistA)
  SetupCPRS(VistA)
else:
  SetupDomain(VistA)
  VistA.write("") # make sure the prompt is available again
StartTaskMan(VistA)
allServiceSections = configParser.getAllServiceSections()
if allServiceSections:
  print ("Adding Service Sections")
  AddServiceSectionByConfig(VistA, allServiceSections)
allLetters = configParser.getAllNotificationLetters()
if allLetters:
  print ("Adding Notification Letters")
  AddNotificationLettersByConfig(VistA, allLetters)
allHolidays = configParser.getAllHolidays()
if allHolidays:
  print ("Adding Holidays")
  AddHolidaysByConfig(VistA, allHolidays)
print ("Adding System Manager")
CreateSystemManager(VistA)
print ("Adding Test Patients")
AddTestPatientsByConfig(VistA, configParser.getAllPatients())
if is_visn0:
  VistA=ConnectToVista('Scenario001.log')
print ("Adding Institutions")
AddInstitutionsByConfig(VistA,configParser.getAllInstitutions())
print ("Adding Divisions")
AddDivisionsByConfig(VistA, configParser.getAllDivisions())
print ("Adding Doctors")
AddDoctorsByConfig(VistA, configParser.getAllDoctors())
print ("Adding Clinics")
AddClinicsByConfig(VistA, configParser.getAllClinics())
print ("Assigning Notification Letter")
AssignNotificationLetter(VistA)
MakeAppointment(VistA,'4/5','0900','60','Audiology','ZZTEST,ONE')
found = VerifyOneAppointment(VistA,'ZZTEST,ONE','Audiology','Apr 05, 2013  9:00 AM','60')
if 'OFF' == 'ON':
  VistA.stopCoverage("C:/Users/contestant/OSEHRA/Dashboards/OSEHRA-Automated-Testing-build/Testing/Temporary/Scenario001.log")
if found:
  sys.exit(0)
else:
  sys.exit(1)

